using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class MMDSkinsScript : MonoBehaviour
{
	// \̎
	public enum SkinType
	{
		Base,
		EyeBrow,
		Eye,
		Lip,
		Other,
	}

	// SĂ̒_f[^^[QbgƂȂ钸_CfbNX
	public int[] targetIndices;

	// [tւ̃xNg
	public Vector3[] morphTarget;

	// \̎
	public SkinType skinType;

	// Ot[̃EFCgl
	float prev_weight = 0;

	// Use this for initialization
	void Start () 
	{
		
	}

	// [ťvZ
	public void Compute(Vector3[] composite)
	{
		float weight = transform.localPosition.z;

		if (weight != prev_weight)
		{
			for (int i = 0; i < targetIndices.Length; i++)
				composite[targetIndices[i]] = morphTarget[i] * weight;
		}

		prev_weight = weight;
	}

	public void Compute(Vector3[] vtxs, int[] indices, Vector3[] source)
	{
		float weight = transform.localPosition.z;

		if (weight != prev_weight)
		{
			for (int i = 0; i < targetIndices.Length; i++)
			{
				//vtxs[targetIndices[i]] += morphTarget[i] * weight * 0.1f;
				vtxs[indices[targetIndices[i]]] = source[targetIndices[i]] + morphTarget[i] * weight * 0.1f;
			}
		}

		prev_weight = weight;
	}
}
